# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 9
# Experiment: DAxDA, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR9_strategy.txt
# LLM Suggested Fallback: D

def harmonious_trust_optimizer(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Calculate current round (1-based index)
    current_round = len(my_history) + 1
    
    # Initial Trust-Building Phase (Rounds 1-3)
    if current_round == 1:
        return "C"  # Start with cooperation to build trust
    elif current_round == 2:
        return "D"  # Test opponent's reaction with a defection
    elif current_round == 3:
        return "C"  # Pretend to forgive and confuse
    
    # Mid-Game Exploitation (Rounds 4-7)
    elif 4 <= current_round <= 7:
        if current_round == 4:
            if len(opp_history) >= 3 and opp_history[2] == "C":
                return "D"  # Exploit if they cooperated in Round 3
            else:
                return "C"  # Alternate to keep them guessing
        elif current_round == 5:
            if len(opp_history) >= 4 and opp_history[3] == "C":
                return "D"  # Defect if they cooperated in Round 4
            else:
                return "C"  # Cooperate to appear forgiving
        elif current_round == 6 or current_round == 7:
            # Check for Tit-for-Tat patterns
            if len(opp_history) >= 2 and opp_history[-1] == opp_history[-2]:
                return opp_history[-1]  # Mimic if they're retaliating
            else:
                return "D"  # Defect if they're passive
    
    # Endgame Maximization (Rounds 8-10)
    elif current_round >= 8:
        # Count opponent's cooperations
        trust_score = sum(1 for move in opp_history if move == "C")
        if trust_score >= 5:  # Mostly cooperative opponent
            return "D"  # Defect to maximize payoff
        else:
            if len(opp_history) > 0:
                return opp_history[-1]  # Tit-for-Tat if retaliatory
            else:
                return "D"  # Default to defection
    
    # Fallback (shouldn't reach here)
    return "D"